/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BlockHitResult;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PartGun
extends APart {
    private final double minYaw;
    private final double maxYaw;
    private final double defaultYaw;
    private final double yawSpeed;
    private final double minPitch;
    private final double maxPitch;
    private final double defaultPitch;
    private final double pitchSpeed;
    private final boolean resetPosition;
    private final boolean isHandHeld;
    private final IWrapperPlayer holdingPlayer;
    private final ComputedVariable muzzleVelocityVar;
    private final ComputedVariable fireDelayVar;
    private final ComputedVariable bulletSpreadFactorVar;
    private final ComputedVariable knockbackVar;
    private final ComputedVariable autoReloadVar;
    private final ComputedVariable blockReloadingVar;
    private final ComputedVariable isSemiAutoVar;
    private final ComputedVariable canLockTargetsVar;
    private final ComputedVariable firingRequestedVar;
    private final ComputedVariable ableToFireVar;
    public final ComputedVariable twoHandedVar;
    private final List<PartInteractable> connectedCrates = new ArrayList<PartInteractable>();
    public ItemBullet lastLoadedBullet;
    public final List<ItemBullet> firedBullets = new ArrayList<ItemBullet>();
    private int bulletsFired;
    private int loadedBulletCount;
    private int reloadingBulletCount;
    private int currentMuzzleGroupIndex;
    private final RotationMatrix internalOrientation;
    private final RotationMatrix prevInternalOrientation;
    private final List<ItemBullet> loadedBullets = new ArrayList<ItemBullet>();
    private final List<Integer> loadedBulletCounts = new ArrayList<Integer>();
    private final List<ItemBullet> reloadingBullets = new ArrayList<ItemBullet>();
    private final List<Integer> reloadingBulletCounts = new ArrayList<Integer>();
    private final Random randomGenerator;
    public GunState state;
    public boolean bulletsPresentOnServer;
    public boolean firedThisTick;
    public boolean firedSinceRequested;
    public boolean isReloading;
    public boolean playerHoldingTrigger;
    public boolean playerPressedTrigger;
    public boolean isHandHeldGunAimed;
    public boolean isHandHeldGunEquipped;
    public boolean isHandHeldGunReloadRequested;
    public boolean isRunningInCoaxialMode;
    private int camOffset;
    private int cooldownTimeRemaining;
    private int reloadDelayRemaining;
    private int reloadStartTimeRemaining;
    private int reloadMainTimeRemaining;
    private int reloadEndTimeRemaining;
    private int windupTimeCurrent;
    private int windupRotation;
    private long lastMillisecondFired;
    public IWrapperEntity lastController;
    private PartSeat lastControllerSeat;
    private Point3D controllerRelativeLookVector = new Point3D();
    public IWrapperEntity entityTarget;
    public PartEngine engineTarget;
    public Point3D targetPosition;
    public EntityBullet currentBullet;
    public final Set<EntityBullet> activeManualBullets = new HashSet<EntityBullet>();
    private final Point3D bulletPosition = new Point3D();
    private final Point3D bulletVelocity = new Point3D();
    private final RotationMatrix bulletOrientation = new RotationMatrix();
    private final Point3D bulletPositionRender = new Point3D();
    private final Point3D bulletVelocityRender = new Point3D();
    private final RotationMatrix bulletOrientationRender = new RotationMatrix();
    private final List<PartSeat> seatsControllingGun = new ArrayList<PartSeat>();
    private final Point3D targetVector = new Point3D();
    private final Point3D targetAngles = new Point3D();
    private final Point3D controllerAngles = new Point3D();
    private final RotationMatrix firingSpreadRotation = new RotationMatrix();
    private final RotationMatrix pitchMuzzleRotation = new RotationMatrix();
    private final RotationMatrix yawMuzzleRotation = new RotationMatrix();
    private final Point3D normalizedConeVector = new Point3D();
    private final Point3D normalizedEntityVector = new Point3D();
    private static final int RAYTRACE_DISTANCE = 750;
    private static final double DEFAULT_CONE_ANGLE = 2.0;

    public PartGun(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartGun item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (placementDefinition.minYaw == -180.0f && placementDefinition.maxYaw == 180.0f) {
            this.minYaw = -180.0;
            this.maxYaw = 180.0;
        } else {
            this.minYaw = ((JSONPart)this.definition).gun.minYaw != 0.0f ? (placementDefinition.minYaw != 0.0f ? (double)Math.max(((JSONPart)this.definition).gun.minYaw, placementDefinition.minYaw) : (double)((JSONPart)this.definition).gun.minYaw) : (double)placementDefinition.minYaw;
            this.maxYaw = ((JSONPart)this.definition).gun.maxYaw != 0.0f ? (placementDefinition.maxYaw != 0.0f ? (double)Math.min(((JSONPart)this.definition).gun.maxYaw, placementDefinition.maxYaw) : (double)((JSONPart)this.definition).gun.maxYaw) : (double)placementDefinition.maxYaw;
        }
        this.defaultYaw = placementDefinition.defaultYaw != 0.0f && (double)placementDefinition.defaultYaw >= this.minYaw && (double)placementDefinition.defaultYaw <= this.maxYaw ? (double)placementDefinition.defaultYaw : (double)((JSONPart)this.definition).gun.defaultYaw;
        this.yawSpeed = ((JSONPart)this.definition).gun.yawSpeed != 0.0f && placementDefinition.yawSpeed != 0.0f ? (((JSONPart)this.definition).gun.yawSpeed < placementDefinition.yawSpeed ? (double)((JSONPart)this.definition).gun.yawSpeed : (double)placementDefinition.yawSpeed) : (((JSONPart)this.definition).gun.yawSpeed != 0.0f ? (double)((JSONPart)this.definition).gun.yawSpeed : (double)placementDefinition.yawSpeed);
        this.minPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.maxPitch != 0.0f ? (double)Math.max(-((JSONPart)this.definition).gun.maxPitch, -placementDefinition.maxPitch) : (double)(-((JSONPart)this.definition).gun.maxPitch)) : (double)(-placementDefinition.maxPitch);
        this.maxPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.minPitch != 0.0f ? (double)Math.min(-((JSONPart)this.definition).gun.minPitch, -placementDefinition.minPitch) : (double)(-((JSONPart)this.definition).gun.minPitch)) : (double)(-placementDefinition.minPitch);
        this.defaultPitch = placementDefinition.defaultPitch != 0.0f && (double)(-placementDefinition.defaultPitch) >= this.minPitch && (double)(-placementDefinition.defaultPitch) <= this.maxPitch ? (double)(-placementDefinition.defaultPitch) : (double)(-((JSONPart)this.definition).gun.defaultPitch);
        this.pitchSpeed = ((JSONPart)this.definition).gun.pitchSpeed != 0.0f && placementDefinition.pitchSpeed != 0.0f ? (((JSONPart)this.definition).gun.pitchSpeed < placementDefinition.pitchSpeed ? (double)((JSONPart)this.definition).gun.pitchSpeed : (double)placementDefinition.pitchSpeed) : (((JSONPart)this.definition).gun.pitchSpeed != 0.0f ? (double)((JSONPart)this.definition).gun.pitchSpeed : (double)placementDefinition.pitchSpeed);
        this.resetPosition = ((JSONPart)this.definition).gun.resetPosition || placementDefinition.resetPosition;
        this.isHandHeld = entityOn instanceof EntityPlayerGun;
        IWrapperPlayer iWrapperPlayer = this.holdingPlayer = this.isHandHeld ? ((EntityPlayerGun)entityOn).player : null;
        if (data != null) {
            int count;
            IWrapperNBT bulletData;
            int i;
            this.state = GunState.values()[data.getInteger("state")];
            this.bulletsFired = data.getInteger("bulletsFired");
            this.currentMuzzleGroupIndex = data.getInteger("currentMuzzleGroupIndex");
            this.internalOrientation = new RotationMatrix();
            if (!this.isHandHeld) {
                this.internalOrientation.setToAngles(data.getPoint3d("internalAngles"));
            }
            for (i = 0; i < data.getInteger("loadedBulletsSize"); ++i) {
                bulletData = data.getData("loadedBullet" + i);
                this.loadedBullets.add((ItemBullet)bulletData.getPackItem());
                count = bulletData.getInteger("count");
                this.loadedBulletCounts.add(count);
                this.loadedBulletCount += count;
            }
            for (i = 0; i < data.getInteger("reloadingBulletsSize"); ++i) {
                bulletData = data.getData("reloadingBullet" + i);
                this.reloadingBullets.add((ItemBullet)bulletData.getPackItem());
                count = bulletData.getInteger("count");
                this.reloadingBulletCounts.add(count);
                this.reloadingBulletCount += count;
            }
            this.reloadStartTimeRemaining = data.getInteger("reloadStartTimeRemaining");
            this.reloadMainTimeRemaining = data.getInteger("reloadMainTimeRemaining");
            this.reloadEndTimeRemaining = data.getInteger("reloadEndTimeRemaining");
            boolean bl = this.isReloading = this.reloadStartTimeRemaining != 0 || this.reloadMainTimeRemaining != 0 || this.reloadEndTimeRemaining != 0;
            if (!this.loadedBullets.isEmpty()) {
                this.lastLoadedBullet = this.loadedBullets.get(0);
                if (this.world.isClient()) {
                    this.bulletsPresentOnServer = true;
                }
            }
            if (data.getBoolean("savedSeed")) {
                long randomSeed = (long)data.getInteger("randomSeedPart1") << 32 | (long)data.getInteger("randomSeedPart2") & 0xFFFFFFFFL;
                this.randomGenerator = new Random(randomSeed);
            } else {
                this.randomGenerator = new Random();
            }
        } else {
            this.state = GunState.INACTIVE;
            this.internalOrientation = new RotationMatrix();
            this.randomGenerator = new Random();
            if (((JSONPart)this.definition).gun.preloadedBullet != null) {
                String[] splitName = ((JSONPart)this.definition).gun.preloadedBullet.split(":");
                ItemBullet loadedBullet = (ItemBullet)PackParser.getItem(splitName[0], splitName[1]);
                if (loadedBullet != null) {
                    this.loadedBullets.add(loadedBullet);
                    this.lastLoadedBullet = loadedBullet;
                    this.loadedBulletCounts.add(((JSONBullet)loadedBullet.definition).bullet.quantity);
                    this.loadedBulletCount = ((JSONBullet)loadedBullet.definition).bullet.quantity;
                } else {
                    InterfaceManager.coreInterface.logError("Tried to load preloaded bullet " + ((JSONPart)this.definition).gun.preloadedBullet + " into gun " + this.definition + " but couldn't because the bullet doesn't exist.  Report this to the pack author!");
                }
            }
        }
        this.prevInternalOrientation = new RotationMatrix().set(this.internalOrientation);
        this.muzzleVelocityVar = new ComputedVariable(this, "muzzleVelocity");
        this.addVariable(this.muzzleVelocityVar);
        this.fireDelayVar = new ComputedVariable(this, "fireDelay");
        this.addVariable(this.fireDelayVar);
        this.bulletSpreadFactorVar = new ComputedVariable(this, "bulletSpreadFactor");
        this.addVariable(this.bulletSpreadFactorVar);
        this.knockbackVar = new ComputedVariable(this, "knockback");
        this.addVariable(this.knockbackVar);
        this.autoReloadVar = new ComputedVariable(this, "autoReload");
        this.addVariable(this.autoReloadVar);
        this.blockReloadingVar = new ComputedVariable(this, "blockReloading");
        this.addVariable(this.blockReloadingVar);
        this.isSemiAutoVar = new ComputedVariable(this, "isSemiAuto");
        this.addVariable(this.isSemiAutoVar);
        this.canLockTargetsVar = new ComputedVariable(this, "canLockTargets");
        this.addVariable(this.canLockTargetsVar);
        this.ableToFireVar = new ComputedVariable(this, "ableToFire");
        this.addVariable(this.ableToFireVar);
        this.firingRequestedVar = new ComputedVariable(this, "firingRequested");
        this.addVariable(this.firingRequestedVar);
        this.twoHandedVar = new ComputedVariable(this, "isTwoHanded");
        this.addVariable(this.twoHandedVar);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        IWrapperItemStack heldStack;
        if (this.reloadDelayRemaining == 0 && this.tryToReload(heldStack = player.getHeldStack(), false) && !player.isCreative()) {
            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
        }
        return true;
    }

    @Override
    public void update() {
        this.firedThisTick = false;
        this.isRunningInCoaxialMode = false;
        this.prevInternalOrientation.set(this.internalOrientation);
        if (this.currentBullet != null && !this.currentBullet.isValid) {
            this.currentBullet = null;
        }
        if (this.isActive && !this.isSpare) {
            IWrapperEntity controller = this.getGunController();
            if (controller != null) {
                this.lastController = controller;
                if (this.isHandHeld) {
                    this.state = this.state.promote(GunState.CONTROLLED);
                } else {
                    this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                    if (!(this.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(this.cachedItem).get(this.lastControllerSeat.gunIndex) != this)) {
                        this.state = this.state.promote(GunState.CONTROLLED);
                    } else {
                        this.state = this.state.demote(GunState.ACTIVE);
                        controller = null;
                        this.entityTarget = null;
                        this.engineTarget = null;
                    }
                }
            }
            if (controller == null) {
                if (!this.parts.isEmpty()) {
                    for (APart part : this.parts) {
                        if (!(part instanceof PartGun) || !part.placementDefinition.isCoAxial || (controller = ((PartGun)part).getGunController()) == null) continue;
                        this.lastController = controller;
                        this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                        if (part.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(part.cachedItem).get(this.lastControllerSeat.gunIndex) != part) continue;
                        this.state = this.state.promote(GunState.CONTROLLED);
                        this.isRunningInCoaxialMode = true;
                        break;
                    }
                }
                if (this.placementDefinition.isCoAxial && this.entityOn instanceof PartGun && (controller = ((PartGun)this.entityOn).getGunController()) != null) {
                    this.lastController = controller;
                    this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                    if (!(this.entityOn.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(this.entityOn.cachedItem).get(this.lastControllerSeat.gunIndex) != this.entityOn)) {
                        this.state = this.state.promote(GunState.CONTROLLED);
                        this.isRunningInCoaxialMode = true;
                    }
                }
                if (controller == null) {
                    this.state = this.state.demote(GunState.ACTIVE);
                    if (this.isHandHeld) {
                        this.remove();
                        return;
                    }
                }
            }
            if (this.state.isAtLeast(GunState.CONTROLLED)) {
                this.handleControl(controller);
                if (this.isRunningInCoaxialMode) {
                    this.state = this.state.demote(GunState.ACTIVE);
                    controller = null;
                    this.entityTarget = null;
                    this.engineTarget = null;
                }
            }
            if (!this.world.isClient() && !this.blockReloadingVar.isActive && this.reloadDelayRemaining == 0 && (!this.isReloading || ((JSONPart)this.definition).gun.isClipless && this.reloadMainTimeRemaining != 0)) {
                if (this.isHandHeld) {
                    if (this.loadedBulletCount == 0 && this.playerPressedTrigger || this.isHandHeldGunReloadRequested || this.autoReloadVar.isActive) {
                        IWrapperInventory inventory = ((IWrapperPlayer)this.lastController).getInventory();
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            if (!this.tryToReload(inventory.getStack(i), this.isHandHeldGunReloadRequested && !((JSONPart)this.definition).gun.isClipless)) continue;
                            inventory.removeFromSlot(i, 1);
                            break;
                        }
                    }
                } else if (this.autoReloadVar.isActive) {
                    block2: for (PartInteractable crate : this.connectedCrates) {
                        if (!crate.isActive) continue;
                        EntityInventoryContainer inventory = crate.inventory;
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            if (!this.tryToReload(inventory.getStack(i), false)) continue;
                            if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue()) continue block2;
                            inventory.removeFromSlot(i, 1);
                            continue block2;
                        }
                    }
                }
            }
            if (this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                if (this.ableToFireVar.isActive) {
                    boolean serverIsPrimaryController;
                    if (this.camOffset <= 0) {
                        if (!((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat != null) {
                            List<PartGun> gunGroup = this.lastControllerSeat.gunGroups.get(this.cachedItem);
                            int thisGunIndex = gunGroup.indexOf(this);
                            this.camOffset = this.lastControllerSeat.gunGroupIndex == thisGunIndex ? (gunGroup.size() > 1 ? (int)this.fireDelayVar.currentValue / gunGroup.size() : 0) : -1;
                        }
                    } else {
                        --this.camOffset;
                    }
                    boolean cycledGun = false;
                    boolean bl = serverIsPrimaryController = this.lastLoadedBullet != null && (((JSONBullet)this.lastLoadedBullet.definition).bullet.isLongRange || !(this.lastController instanceof IWrapperPlayer));
                    if (this.loadedBulletCount > 0 || this.world.isClient() && serverIsPrimaryController && this.bulletsPresentOnServer) {
                        this.state = this.state.promote(GunState.FIRING_CURRENTLY);
                        if (this.camOffset == 0) {
                            for (JSONMuzzle muzzle : ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles) {
                                for (int i = 0; i < (((JSONBullet)this.lastLoadedBullet.definition).bullet.pellets > 0 ? ((JSONBullet)this.lastLoadedBullet.definition).bullet.pellets : 1); ++i) {
                                    EntityBullet newBullet;
                                    ++this.bulletsFired;
                                    if (!this.world.isClient() && !serverIsPrimaryController) continue;
                                    this.setBulletSpawn(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, muzzle, true);
                                    if (((JSONBullet)this.lastLoadedBullet.definition).bullet.turnRate > 0.0f) {
                                        if (this.entityTarget != null) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.bulletsFired, this.entityTarget);
                                        } else if (this.engineTarget != null) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.bulletsFired, this.engineTarget);
                                        } else if (((JSONPart)this.definition).gun.lockOnType == JSONPart.LockOnType.MANUAL) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.bulletsFired, this.targetPosition);
                                            this.activeManualBullets.add(newBullet);
                                        } else {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.bulletsFired);
                                        }
                                    } else {
                                        newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.bulletsFired);
                                    }
                                    this.world.addEntity(newBullet);
                                }
                                if (this.isHandHeld) {
                                    if (!this.world.isClient()) {
                                        this.performGunKnockback();
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.KNOCKBACK));
                                    } else if (InterfaceManager.clientInterface.getClientPlayer().equals(this.lastController)) {
                                        InterfaceManager.packetInterface.sendToServer(new PacketPartGun(this, PacketPartGun.Request.KNOCKBACK));
                                    }
                                }
                                this.firedBullets.add(this.lastLoadedBullet);
                                if (this.loadedBulletCount <= 0) continue;
                                --this.loadedBulletCount;
                                int count = this.loadedBulletCounts.get(0);
                                if (--count == 0) {
                                    this.loadedBullets.remove(0);
                                    this.loadedBulletCounts.remove(0);
                                    if (!this.loadedBullets.isEmpty()) {
                                        this.lastLoadedBullet = this.loadedBullets.get(0);
                                        continue;
                                    }
                                    if (this.world.isClient()) break;
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.BULLETS_OUT));
                                    break;
                                }
                                this.loadedBulletCounts.set(0, count);
                            }
                            this.cooldownTimeRemaining = (int)this.fireDelayVar.currentValue;
                            this.firedThisTick = true;
                            this.firedSinceRequested = true;
                            cycledGun = true;
                            this.lastMillisecondFired = System.currentTimeMillis();
                            if (((JSONPart)this.definition).gun.muzzleGroups.size() == ++this.currentMuzzleGroupIndex) {
                                this.currentMuzzleGroupIndex = 0;
                            }
                        }
                    } else if (this.camOffset == 0) {
                        cycledGun = true;
                    }
                    if (cycledGun && this.lastControllerSeat != null) {
                        List<PartGun> gunGroup = this.lastControllerSeat.gunGroups.get(this.cachedItem);
                        int currentIndex = gunGroup.indexOf(this);
                        this.lastControllerSeat.gunGroupIndex = currentIndex + 1 < gunGroup.size() ? currentIndex + 1 : 0;
                    }
                } else {
                    this.state = this.state.demote(GunState.FIRING_REQUESTED);
                }
            } else {
                this.firedSinceRequested = false;
            }
            if (this.state.isAtLeast(GunState.FIRING_CURRENTLY)) {
                this.reloadDelayRemaining = ((JSONPart)this.definition).gun.reloadDelay;
            } else if (this.reloadDelayRemaining > 0) {
                --this.reloadDelayRemaining;
            }
        } else {
            this.state = GunState.INACTIVE;
            this.entityTarget = null;
            this.engineTarget = null;
            if (this.resetPosition) {
                this.handleMovement(this.defaultYaw - this.internalOrientation.angles.y, this.defaultPitch - this.internalOrientation.angles.x);
            }
        }
        if (this.isReloading) {
            if (this.reloadStartTimeRemaining > 0) {
                --this.reloadStartTimeRemaining;
            } else if (this.reloadMainTimeRemaining > 0) {
                --this.reloadMainTimeRemaining;
                if (this.reloadMainTimeRemaining == 0) {
                    ItemBullet bulletToLoad = this.reloadingBullets.remove(0);
                    int countToLoad = this.reloadingBulletCounts.remove(0);
                    this.loadedBullets.add(bulletToLoad);
                    this.loadedBulletCounts.add(countToLoad);
                    if (this.loadedBullets.size() == 1) {
                        this.lastLoadedBullet = bulletToLoad;
                    }
                    this.loadedBulletCount += countToLoad;
                    this.reloadingBulletCount -= countToLoad;
                    this.firedBullets.clear();
                    if (!this.world.isClient()) {
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.BULLETS_PRESENT));
                    }
                    if (this.reloadingBullets.isEmpty() && this.reloadEndTimeRemaining == 0) {
                        this.isReloading = false;
                    }
                }
            } else if (!this.reloadingBullets.isEmpty()) {
                this.reloadMainTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
            } else if (--this.reloadEndTimeRemaining == 0) {
                this.isReloading = false;
            }
        }
        if (this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
            if (this.windupTimeCurrent < ((JSONPart)this.definition).gun.windupTime) {
                ++this.windupTimeCurrent;
            }
        } else if (this.windupTimeCurrent > 0) {
            this.windupTimeCurrent = ((JSONPart)this.definition).gun.windsDownInstantly ? 0 : --this.windupTimeCurrent;
        }
        this.windupRotation += this.windupTimeCurrent;
        if (this.cooldownTimeRemaining > 0) {
            --this.cooldownTimeRemaining;
        }
        this.isHandHeldGunReloadRequested = false;
        this.playerPressedTrigger = false;
        super.update();
        if (this.lastControllerSeat != null && this.parts.contains(this.lastControllerSeat)) {
            this.orientation.convertToAngles();
            this.lastControllerSeat.riderRelativeOrientation.angles.y -= this.orientation.angles.y - this.prevOrientation.angles.y;
            this.lastControllerSeat.riderRelativeOrientation.angles.x -= this.orientation.angles.x - this.prevOrientation.angles.x;
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.seatsControllingGun.clear();
        this.addLinkedPartsToList(this.seatsControllingGun, PartSeat.class);
        for (APart part : this.parts) {
            if (!(part instanceof PartSeat)) continue;
            this.seatsControllingGun.add((PartSeat)part);
        }
        this.connectedCrates.clear();
        for (APart part : this.parts) {
            if (!(part instanceof PartInteractable)) continue;
            this.connectedCrates.add((PartInteractable)part);
        }
        this.addLinkedPartsToList(this.connectedCrates, PartInteractable.class);
        this.connectedCrates.removeIf(crate -> ((JSONPart)crate.definition).interactable.interactionType != JSONPart.InteractableComponentType.CRATE || !((JSONPart)crate.definition).interactable.feedsVehicles);
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        this.muzzleVelocityVar.setTo(((JSONPart)this.definition).gun.muzzleVelocity, false);
        this.fireDelayVar.setTo(((JSONPart)this.definition).gun.fireDelay, false);
        this.bulletSpreadFactorVar.setTo(((JSONPart)this.definition).gun.bulletSpreadFactor, false);
        this.knockbackVar.setTo(((JSONPart)this.definition).gun.knockback, false);
        this.autoReloadVar.setTo(((JSONPart)this.definition).gun.autoReload ? 1.0 : 0.0, false);
        this.blockReloadingVar.setTo(((JSONPart)this.definition).gun.blockReloading ? 1.0 : 0.0, false);
        this.isSemiAutoVar.setTo(((JSONPart)this.definition).gun.isSemiAuto ? 1.0 : 0.0, false);
        this.canLockTargetsVar.setTo(((JSONPart)this.definition).gun.canLockTargets ? 1.0 : 0.0, false);
        this.twoHandedVar.setTo(((JSONPart)this.definition).gun.isTwoHanded ? 1.0 : 0.0, false);
        this.ableToFireVar.setTo(this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime && this.cooldownTimeRemaining == 0 && !this.isReloading && (!this.isSemiAutoVar.isActive || !this.firedSinceRequested) ? 1.0 : 0.0, false);
        this.firingRequestedVar.setTo(this.playerHoldingTrigger ? 1.0 : 0.0, false);
    }

    @Override
    public void updateVariableModifiers() {
        if (((JSONPart)this.definition).variableModifiers != null) {
            block8: for (JSONVariableModifier modifier : ((JSONPart)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "gun_yaw": {
                        this.internalOrientation.angles.y = this.adjustVariable(modifier, this.internalOrientation.angles.y);
                        continue block8;
                    }
                    case "gun_pitch": {
                        this.internalOrientation.angles.x = this.adjustVariable(modifier, this.internalOrientation.angles.x);
                        continue block8;
                    }
                }
                ComputedVariable variable = this.getOrCreateVariable(modifier.variable);
                variable.setTo(this.adjustVariable(modifier, variable.currentValue), false);
            }
        }
    }

    private void handleControl(IWrapperEntity controller) {
        if (!(controller instanceof IWrapperPlayer)) {
            boolean checkForCloser;
            boolean bl = checkForCloser = this.entityTarget != null && this.ticksExisted % 20L == 0L;
            if (this.entityTarget == null || checkForCloser) {
                for (IWrapperEntity entity : this.world.getEntitiesHostile(controller, 48.0)) {
                    if (!this.validateTarget(controller, entity)) continue;
                    if (this.entityTarget != null) {
                        double distanceToBeat = this.position.distanceTo(this.entityTarget.getPosition());
                        if (checkForCloser) {
                            distanceToBeat += 5.0;
                        }
                        if (this.position.distanceTo(entity.getPosition()) > distanceToBeat) continue;
                    }
                    this.entityTarget = entity;
                }
            }
            if (this.entityTarget != null) {
                if (this.validateTarget(controller, this.entityTarget)) {
                    this.controllerAngles.set(this.targetVector).getAngles(true);
                    controller.setYaw(this.controllerAngles.y);
                    controller.setPitch(this.controllerAngles.x);
                    this.state = Math.abs(this.targetAngles.y - this.internalOrientation.angles.y) < this.yawSpeed && Math.abs(this.targetAngles.x - this.internalOrientation.angles.x) < this.pitchSpeed ? this.state.promote(GunState.FIRING_REQUESTED) : this.state.demote(GunState.CONTROLLED);
                } else {
                    this.entityTarget = null;
                    this.state = this.state.demote(GunState.CONTROLLED);
                }
            } else {
                this.state = this.state.demote(GunState.CONTROLLED);
            }
        } else {
            if (this.canLockTargetsVar.isActive || this.lastLoadedBullet != null && ((JSONBullet)this.lastLoadedBullet.definition).bullet.turnRate > 0.0f) {
                Point3D startPoint = null;
                Point3D searchVector = null;
                double coneAngle = 0.0;
                switch (((JSONPart)this.definition).gun.lockOnType) {
                    case DEFAULT: {
                        startPoint = controller.getEyePosition();
                        searchVector = controller.getLineOfSight(750.0);
                        coneAngle = 2.0;
                        break;
                    }
                    case BORESIGHT: {
                        startPoint = this.position;
                        searchVector = new Point3D(0.0, 0.0, ((JSONPart)this.definition).gun.lockRange).rotate(this.orientation);
                        coneAngle = ((JSONPart)this.definition).gun.lockMaxAngle;
                        break;
                    }
                    case RADAR: {
                        break;
                    }
                    case MANUAL: {
                        if (this.targetPosition != null) break;
                        this.targetPosition = new Point3D();
                    }
                }
                this.engineTarget = null;
                this.entityTarget = null;
                if (startPoint != null) {
                    double targetAngle;
                    double entityDistance;
                    if (((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.HARD || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.AIRCRAFT || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.GROUND) {
                        this.normalizedConeVector.set(searchVector).normalize();
                        EntityVehicleF_Physics vehicleTarget = null;
                        double smallestDistance = searchVector.length();
                        for (EntityVehicleF_Physics vehicle : this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                            if (vehicle == this.vehicleOn || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.AIRCRAFT && !((JSONVehicle)vehicle.definition).motorized.isAircraft || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.GROUND && ((JSONVehicle)vehicle.definition).motorized.isAircraft) continue;
                            this.targetVector.set(vehicle.position).subtract(startPoint);
                            if (this.world.getBlockHit(startPoint, this.targetVector) != null || !((entityDistance = vehicle.position.distanceTo(startPoint)) < smallestDistance)) continue;
                            this.normalizedEntityVector.set(vehicle.position).subtract(startPoint).normalize();
                            targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                            if (!(targetAngle < coneAngle)) continue;
                            smallestDistance = entityDistance;
                            vehicleTarget = vehicle;
                        }
                        if (vehicleTarget != null && !vehicleTarget.outOfHealth) {
                            for (APart part : vehicleTarget.parts) {
                                if (!(part instanceof PartEngine)) continue;
                                this.engineTarget = (PartEngine)part;
                                break;
                            }
                        }
                    }
                    if (this.engineTarget == null && ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.SOFT) {
                        this.normalizedConeVector.set(searchVector).normalize();
                        double smallestDistance = searchVector.length();
                        BoundingBox searchBox = new BoundingBox(this.position, smallestDistance, smallestDistance, smallestDistance);
                        for (IWrapperEntity entity : this.world.getEntitiesWithin(searchBox)) {
                            if (!entity.isValid() || entity == controller) continue;
                            this.targetVector.set(entity.getPosition()).subtract(startPoint);
                            if (this.world.getBlockHit(startPoint, this.targetVector) != null || !((entityDistance = entity.getPosition().distanceTo(startPoint)) < smallestDistance)) continue;
                            this.normalizedEntityVector.set(entity.getPosition()).subtract(startPoint).normalize();
                            targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                            if (!(targetAngle < coneAngle)) continue;
                            smallestDistance = entityDistance;
                            this.entityTarget = entity;
                        }
                    }
                }
            }
            if (!this.activeManualBullets.isEmpty()) {
                Point3D laserStart = controller.getEyePosition().copy();
                BlockHitResult laserHit = this.world.getBlockHit(laserStart, controller.getLineOfSight(2048.0));
                if (laserHit != null) {
                    this.targetPosition.set(laserHit.hitPosition);
                } else {
                    this.targetPosition.set(laserStart).add(controller.getLineOfSight(1024.0));
                }
            }
            this.state = this.firingRequestedVar.isActive ? this.state.promote(GunState.FIRING_REQUESTED) : this.state.demote(GunState.CONTROLLED);
        }
        if (this.lastControllerSeat != null) {
            this.controllerRelativeLookVector.computeVectorAngles(controller.getOrientation(), this.zeroReferenceOrientation);
            this.handleMovement(this.controllerRelativeLookVector.y - this.internalOrientation.angles.y, this.controllerRelativeLookVector.x - this.internalOrientation.angles.x);
            if (!this.lastControllerSeat.externalAnglesRotated.isZero() && this.lastControllerSeat.placementDefinition.animations != null) {
                boolean updateYaw = false;
                boolean updatePitch = false;
                for (JSONAnimationDefinition def : this.lastControllerSeat.placementDefinition.animations) {
                    if (def.variable.contains("gun_yaw")) {
                        updateYaw = true;
                        continue;
                    }
                    if (!def.variable.contains("gun_pitch")) continue;
                    updatePitch = true;
                }
                if (updateYaw) {
                    this.lastControllerSeat.riderRelativeOrientation.angles.y -= this.internalOrientation.angles.y - this.prevInternalOrientation.angles.y;
                }
                if (updatePitch) {
                    this.lastControllerSeat.riderRelativeOrientation.angles.x -= this.internalOrientation.angles.x - this.prevInternalOrientation.angles.x;
                }
            }
        }
    }

    private boolean validateTarget(IWrapperEntity controller, IWrapperEntity target) {
        if (target.isValid()) {
            JSONMuzzle muzzleDef = ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles.get(0);
            if (muzzleDef.center != null) {
                this.bulletPosition.set(muzzleDef.center);
            } else {
                this.bulletPosition.set(0.0, 0.0, 0.0);
            }
            this.bulletPosition.rotate(this.internalOrientation).add(this.position);
            this.targetVector.set(target.getPosition());
            this.targetVector.y += target.getEyeHeight() / 2.0;
            this.targetVector.subtract(this.bulletPosition);
            this.targetAngles.set(this.targetVector).reOrigin(this.zeroReferenceOrientation).getAngles(true);
            if ((this.minYaw != -180.0 || this.maxYaw != 180.0) && (this.targetAngles.y < this.minYaw || this.targetAngles.y > this.maxYaw)) {
                return false;
            }
            if (this.targetAngles.x < this.minPitch || this.targetAngles.x > this.maxPitch) {
                return false;
            }
            System.out.println(this.bulletPosition);
            return true;
        }
        return false;
    }

    private void handleMovement(double deltaYaw, double deltaPitch) {
        if (deltaYaw != 0.0 || deltaPitch != 0.0) {
            if (deltaYaw != 0.0) {
                if (deltaYaw < -180.0) {
                    deltaYaw += 360.0;
                }
                if (deltaYaw > 180.0) {
                    deltaYaw -= 360.0;
                }
                if (deltaYaw < 0.0) {
                    if (deltaYaw < -this.yawSpeed) {
                        deltaYaw = -this.yawSpeed;
                    }
                    this.internalOrientation.angles.y += deltaYaw;
                } else if (deltaYaw > 0.0) {
                    if (deltaYaw > this.yawSpeed) {
                        deltaYaw = this.yawSpeed;
                    }
                    this.internalOrientation.angles.y += deltaYaw;
                }
                if (this.minYaw == -180.0 && this.maxYaw == 180.0) {
                    if (this.internalOrientation.angles.y > 180.0) {
                        this.internalOrientation.angles.y -= 360.0;
                        this.prevInternalOrientation.angles.y -= 360.0;
                    } else if (this.internalOrientation.angles.y < -180.0) {
                        this.internalOrientation.angles.y += 360.0;
                        this.prevInternalOrientation.angles.y += 360.0;
                    }
                } else {
                    if (this.internalOrientation.angles.y > this.maxYaw) {
                        this.internalOrientation.angles.y = this.maxYaw;
                    }
                    if (this.internalOrientation.angles.y < this.minYaw) {
                        this.internalOrientation.angles.y = this.minYaw;
                    }
                }
            }
            if (deltaPitch != 0.0) {
                if (deltaPitch < 0.0) {
                    if (deltaPitch < -this.pitchSpeed) {
                        deltaPitch = -this.pitchSpeed;
                    }
                    this.internalOrientation.angles.x += deltaPitch;
                } else if (deltaPitch > 0.0) {
                    if (deltaPitch > this.pitchSpeed) {
                        deltaPitch = this.pitchSpeed;
                    }
                    this.internalOrientation.angles.x += deltaPitch;
                }
                if (this.internalOrientation.angles.x > this.maxPitch) {
                    this.internalOrientation.angles.x = this.maxPitch;
                }
                if (this.internalOrientation.angles.x < this.minPitch) {
                    this.internalOrientation.angles.x = this.minPitch;
                }
            }
        }
    }

    public boolean tryToReload(IWrapperItemStack stack, boolean swapIfFull) {
        AItemBase item = stack.getItem();
        if (item instanceof ItemBullet) {
            ItemBullet bulletItem = (ItemBullet)item;
            if (((JSONBullet)bulletItem.definition).bullet != null && ((JSONBullet)bulletItem.definition).bullet.diameter == ((JSONPart)this.definition).gun.diameter && ((JSONBullet)bulletItem.definition).bullet.caseLength >= ((JSONPart)this.definition).gun.minCaseLength && ((JSONBullet)bulletItem.definition).bullet.caseLength <= ((JSONPart)this.definition).gun.maxCaseLength) {
                IWrapperNBT data;
                if (this.isHandHeld && this.loadedBulletCount > 0 && !((JSONPart)this.definition).gun.isClipless) {
                    IWrapperNBT data2 = InterfaceManager.coreInterface.getNewNBTWrapper();
                    data2.setInteger("bulletQty", this.loadedBulletCount);
                    IWrapperItemStack bulletStack = this.loadedBullets.get(0).getNewStack(data2);
                    this.clearBullets();
                    if (this.holdingPlayer.getInventory().addStack(bulletStack)) {
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.CLEAR_ONCLIENT));
                    } else {
                        return false;
                    }
                }
                int bulletQty = this.isHandHeld ? ((data = stack.getData()) != null ? data.getInteger("bulletQty") : ((JSONBullet)bulletItem.definition).bullet.quantity) : ((JSONBullet)bulletItem.definition).bullet.quantity;
                if (bulletQty + this.loadedBulletCount + this.reloadingBulletCount <= ((JSONPart)this.definition).gun.capacity) {
                    this.setReloadVars(bulletItem, bulletQty);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, bulletItem, bulletQty));
                    return true;
                }
            }
        }
        return false;
    }

    public void setReloadVars(ItemBullet bulletItem, int bulletQty) {
        if (this.reloadingBullets.isEmpty()) {
            this.reloadStartTimeRemaining = ((JSONPart)this.definition).gun.reloadStartTime;
        }
        this.reloadingBullets.add(bulletItem);
        this.reloadingBulletCounts.add(bulletQty);
        this.reloadingBulletCount += bulletQty;
        this.reloadMainTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
        this.reloadEndTimeRemaining = ((JSONPart)this.definition).gun.reloadEndTime;
        this.isReloading = true;
    }

    public void clearBullets() {
        this.loadedBullets.clear();
        this.loadedBulletCounts.clear();
        this.loadedBulletCount = 0;
    }

    public String getBulletText() {
        if (this.loadedBulletCount > 0) {
            return this.lastLoadedBullet.getItemName() + "X" + this.loadedBulletCounts.get(0);
        }
        return "EMPTY";
    }

    public IWrapperEntity getGunController() {
        if (this.masterEntity.outOfHealth) {
            return null;
        }
        if (this.isHandHeld) {
            return this.holdingPlayer;
        }
        if (this.entityOn instanceof PartSeat && this.entityOn.rider != null) {
            return this.entityOn.rider;
        }
        for (APart part : this.parts) {
            if (!(part instanceof PartSeat) || part.rider == null) continue;
            return part.rider;
        }
        for (PartSeat seat : this.seatsControllingGun) {
            if (seat.rider == null) continue;
            return seat.rider;
        }
        return null;
    }

    public void performGunKnockback() {
        if (this.knockbackVar.currentValue != 0.0) {
            this.holdingPlayer.applyMotion(new Point3D(0.0, 0.0, 1.0).rotate(this.orientation).scale(-this.knockbackVar.currentValue));
        }
    }

    public void setBulletSpawn(Point3D bulletPosition, Point3D bulletVelocity, RotationMatrix bulletOrientation, JSONMuzzle muzzle, boolean addSpread) {
        if (this.muzzleVelocityVar.currentValue != 0.0) {
            bulletVelocity.set(0.0, 0.0, this.muzzleVelocityVar.currentValue / 20.0);
            if (addSpread) {
                if (this.lastLoadedBullet == null) {
                    if (this.bulletSpreadFactorVar.isActive) {
                        this.firingSpreadRotation.angles.set((double)(this.randomGenerator.nextFloat() - 0.5f) * this.bulletSpreadFactorVar.currentValue, (double)(this.randomGenerator.nextFloat() - 0.5f) * this.bulletSpreadFactorVar.currentValue, 0.0);
                        bulletVelocity.rotate(this.firingSpreadRotation);
                    }
                } else if (this.bulletSpreadFactorVar.isActive || ((JSONBullet)this.lastLoadedBullet.definition).bullet.pelletSpreadFactor > 0.0f) {
                    this.firingSpreadRotation.angles.set((double)(this.randomGenerator.nextFloat() - 0.5f) * (this.bulletSpreadFactorVar.currentValue + (double)((JSONBullet)this.lastLoadedBullet.definition).bullet.pelletSpreadFactor), (double)(this.randomGenerator.nextFloat() - 0.5f) * (this.bulletSpreadFactorVar.currentValue + (double)((JSONBullet)this.lastLoadedBullet.definition).bullet.pelletSpreadFactor), 0.0);
                    bulletVelocity.rotate(this.firingSpreadRotation);
                }
            }
            if (muzzle.rot != null) {
                bulletVelocity.rotate(muzzle.rot);
            }
            bulletVelocity.rotate(this.internalOrientation).rotate(this.zeroReferenceOrientation);
        } else {
            bulletVelocity.set(0.0, 0.0, 0.0);
        }
        if (!((JSONPart)this.definition).gun.disableInheritedMotion) {
            if (this.vehicleOn != null) {
                bulletVelocity.addScaled(this.motion, this.vehicleOn.speedFactor);
            } else {
                bulletVelocity.add(this.motion);
            }
        }
        bulletPosition.set(muzzle.pos);
        if (muzzle.center != null) {
            this.pitchMuzzleRotation.setToZero().rotateX(this.internalOrientation.angles.x);
            this.yawMuzzleRotation.setToZero().rotateY(this.internalOrientation.angles.y);
            bulletPosition.subtract(muzzle.center).rotate(this.pitchMuzzleRotation).add(muzzle.center).rotate(this.yawMuzzleRotation);
        } else {
            bulletPosition.rotate(this.internalOrientation);
        }
        bulletPosition.rotate(this.zeroReferenceOrientation).add(this.position);
        bulletOrientation.set(this.zeroReferenceOrientation).multiply(this.internalOrientation);
        if (muzzle.rot != null && !((JSONPart)this.definition).gun.disableMuzzleOrientation) {
            bulletOrientation.multiply(muzzle.rot);
        }
    }

    public double getLockedOnDirection() {
        Point3D referencePos;
        double direction = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.engineTarget.vehicleOn.position.z + referencePos.z, -this.engineTarget.vehicleOn.position.x + referencePos.x)) + 90.0 + this.orientation.angles.y;
        } else if (this.entityTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x)) + 90.0 + this.orientation.angles.y;
        }
        while (direction < -180.0) {
            direction += 360.0;
        }
        while (direction > 180.0) {
            direction -= 360.0;
        }
        return direction;
    }

    public double getLockedOnAngle() {
        Point3D referencePos;
        double angle = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.engineTarget.position.y + referencePos.y, Math.hypot(-this.engineTarget.position.z + referencePos.z, -this.engineTarget.position.x + referencePos.x))) + this.orientation.angles.x;
        } else if (this.entityTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().y + referencePos.y, Math.hypot(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x))) + this.orientation.angles.x;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public Point3D getLockedOnLeadPoint() {
        Point3D leadPoint = new Point3D();
        double ticksToTarget = 0.0;
        if (this.engineTarget != null) {
            ticksToTarget = this.engineTarget.vehicleOn.position.distanceTo(this.position) / (this.muzzleVelocityVar.currentValue / 20.0);
            leadPoint.set(this.engineTarget.vehicleOn.position).addScaled(this.engineTarget.vehicleOn.motion, this.engineTarget.vehicleOn.speedFactor * ticksToTarget);
        } else if (this.entityTarget != null) {
            ticksToTarget = this.entityTarget.getPosition().distanceTo(this.position) / (this.knockbackVar.currentValue / 20.0);
            leadPoint.set(this.entityTarget.getPosition()).addScaled(this.entityTarget.getVelocity(), ticksToTarget);
        }
        return leadPoint;
    }

    public double getLeadPointDirection() {
        double direction = 0.0;
        if (this.engineTarget != null || this.entityTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x)) + 90.0 + this.orientation.angles.y;
        }
        while (direction < -180.0) {
            direction += 360.0;
        }
        while (direction > 180.0) {
            direction -= 360.0;
        }
        return direction;
    }

    public double getLeadAngleY() {
        Point3D referencePos;
        double angle = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x - (-Math.toDegrees(Math.atan2(-this.engineTarget.position.y + referencePos.y, Math.hypot(-this.engineTarget.position.z + referencePos.z, -this.engineTarget.position.x + referencePos.x))) + this.orientation.angles.x);
        } else if (this.entityTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x - (-Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().y + referencePos.y, Math.hypot(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x))) + this.orientation.angles.x);
        }
        return angle;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "gun_inhand": {
                return new ComputedVariable(this, variable, partialTicks -> this.isHandHeld ? 1.0 : 0.0, false);
            }
            case "gun_inhand_sneaking": {
                return new ComputedVariable(this, variable, partialTicks -> this.isHandHeld && this.holdingPlayer.isSneaking() ? 1.0 : 0.0, false);
            }
            case "gun_inhand_aiming": {
                return new ComputedVariable(this, variable, partialTicks -> this.isHandHeldGunAimed ? 1.0 : 0.0, false);
            }
            case "gun_inhand_equipped": {
                return new ComputedVariable(this, variable, partialTicks -> this.isHandHeldGunEquipped && this.isValid ? 1.0 : 0.0, false);
            }
            case "gun_controller_firstperson": {
                return new ComputedVariable(this, variable, partialTicks -> InterfaceManager.clientInterface.getClientPlayer().equals(this.lastController) && InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? 1.0 : 0.0, false);
            }
            case "gun_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.state.isAtLeast(GunState.CONTROLLED) ? 1.0 : 0.0, false);
            }
            case "gun_firing": {
                return new ComputedVariable(this, variable, partialTicks -> this.state.isAtLeast(GunState.FIRING_REQUESTED) ? 1.0 : 0.0, false);
            }
            case "gun_fired": {
                return new ComputedVariable(this, variable, partialTicks -> this.firedThisTick ? 1.0 : 0.0, false);
            }
            case "gun_muzzleflash": {
                return new ComputedVariable(this, variable, partialTicks -> this.firedThisTick && this.lastMillisecondFired + 25L < System.currentTimeMillis() ? 1.0 : 0.0, true);
            }
            case "gun_lockedon": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null || this.engineTarget != null ? 1.0 : 0.0, false);
            }
            case "gun_lockedon_x": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.entityTarget.getPosition().x : (this.engineTarget != null ? this.engineTarget.position.x : 0.0), false);
            }
            case "gun_lockedon_y": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.entityTarget.getPosition().y : (this.engineTarget != null ? this.engineTarget.position.y : 0.0), false);
            }
            case "gun_lockedon_z": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.entityTarget.getPosition().z : (this.engineTarget != null ? this.engineTarget.position.z : 0.0), false);
            }
            case "gun_lockedon_direction": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.getLockedOnDirection() : (this.engineTarget != null ? this.getLockedOnDirection() : 0.0), false);
            }
            case "gun_lockedon_angle": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.getLockedOnAngle() : (this.engineTarget != null ? this.getLockedOnAngle() : 0.0), false);
            }
            case "gun_lockedon_leadpoint_direction": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.getLeadPointDirection() : (this.engineTarget != null ? this.getLeadPointDirection() : 0.0), false);
            }
            case "gun_lockedon_leadpoint_angle": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x : (this.engineTarget != null ? -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x : 0.0), false);
            }
            case "gun_lockedon_distance": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.entityTarget.getPosition().distanceTo(this.position) : (this.engineTarget != null ? this.engineTarget.position.distanceTo(this.position) : 0.0), false);
            }
            case "gun_lockedon_leadangle_x": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.getLeadPointDirection() - this.getLockedOnDirection() : (this.engineTarget != null ? this.getLeadPointDirection() - this.getLockedOnDirection() : 0.0), false);
            }
            case "gun_lockedon_leadangle_y": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityTarget != null ? this.getLeadAngleY() : (this.engineTarget != null ? this.getLeadAngleY() : 0.0), false);
            }
            case "gun_pitch": {
                return new ComputedVariable(this, variable, partialTicks -> partialTicks != 0.0f ? this.prevInternalOrientation.angles.x + (this.internalOrientation.angles.x - this.prevInternalOrientation.angles.x) * (double)partialTicks : this.internalOrientation.angles.x, true);
            }
            case "gun_yaw": {
                return new ComputedVariable(this, variable, partialTicks -> partialTicks != 0.0f ? this.prevInternalOrientation.angles.y + (this.internalOrientation.angles.y - this.prevInternalOrientation.angles.y) * (double)partialTicks : this.internalOrientation.angles.y, true);
            }
            case "gun_pitching": {
                return new ComputedVariable(this, variable, partialTicks -> Math.abs(this.prevInternalOrientation.angles.x - this.internalOrientation.angles.x) > 0.01 ? 1.0 : 0.0, false);
            }
            case "gun_yawing": {
                return new ComputedVariable(this, variable, partialTicks -> Math.abs(this.prevInternalOrientation.angles.y - this.internalOrientation.angles.y) > 0.01 ? 1.0 : 0.0, false);
            }
            case "gun_cooldown": {
                return new ComputedVariable(this, variable, partialTicks -> this.cooldownTimeRemaining > 0 ? 1.0 : 0.0, false);
            }
            case "gun_windup_time": {
                return new ComputedVariable(this, variable, partialTicks -> this.windupTimeCurrent, false);
            }
            case "gun_windup_rotation": {
                return new ComputedVariable(this, variable, partialTicks -> this.windupRotation, false);
            }
            case "gun_windup_complete": {
                return new ComputedVariable(this, variable, partialTicks -> this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime ? 1.0 : 0.0, false);
            }
            case "gun_reload": {
                return new ComputedVariable(this, variable, partialTicks -> this.isReloading ? 1.0 : 0.0, false);
            }
            case "gun_reload_windup": {
                return new ComputedVariable(this, variable, partialTicks -> this.isReloading && this.reloadStartTimeRemaining > 0 ? 1.0 : 0.0, false);
            }
            case "gun_reload_main": {
                return new ComputedVariable(this, variable, partialTicks -> this.isReloading && this.reloadStartTimeRemaining == 0 && this.reloadMainTimeRemaining > 0 ? 1.0 : 0.0, false);
            }
            case "gun_reload_winddown": {
                return new ComputedVariable(this, variable, partialTicks -> this.isReloading && this.reloadStartTimeRemaining == 0 && this.reloadMainTimeRemaining == 0 && this.reloadEndTimeRemaining > 0 ? 1.0 : 0.0, false);
            }
            case "gun_ammo_count": {
                return new ComputedVariable(this, variable, partialTicks -> this.loadedBulletCount, false);
            }
            case "gun_ammo_count_reloading": {
                return new ComputedVariable(this, variable, partialTicks -> this.reloadingBulletCount, false);
            }
            case "gun_ammo_percent": {
                return new ComputedVariable(this, variable, partialTicks -> this.loadedBulletCount / ((JSONPart)this.definition).gun.capacity, false);
            }
            case "gun_active_muzzlegroup": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentMuzzleGroupIndex + 1, false);
            }
            case "gun_bullet_present": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? 1.0 : 0.0, false);
            }
            case "gun_bullet_x": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? this.currentBullet.getRelativePos(1, partialTicks) : 0.0, true);
            }
            case "gun_bullet_y": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? this.currentBullet.getRelativePos(2, partialTicks) : 0.0, true);
            }
            case "gun_bullet_z": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? this.currentBullet.getRelativePos(3, partialTicks) : 0.0, true);
            }
            case "gun_bullet_yaw": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? this.currentBullet.orientation.angles.y - this.orientation.angles.y : 0.0, false);
            }
            case "gun_bullet_pitch": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentBullet != null ? this.currentBullet.orientation.angles.x - this.orientation.angles.x : 0.0, false);
            }
        }
        if (variable.startsWith("gun_ammo_") && variable.endsWith("_loaded")) {
            int index = Integer.parseInt(variable.substring("gun_ammo_".length(), "gun_ammo_".length() + 1));
            return new ComputedVariable(this, variable, partialTicks -> this.loadedBulletCount >= index ? 1.0 : 0.0, false);
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        if (textDef.variableName.equals("gun_lockedon_name")) {
            return this.entityTarget != null ? this.entityTarget.getName() : (this.engineTarget != null ? this.engineTarget.masterEntity.toString() : "");
        }
        return super.getRawTextVariableValue(textDef, partialTicks);
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        if (this.entityOn.isVariableListTrue(this.placementDefinition.interactableVariables)) {
            super.renderBoundingBoxes(transform);
            for (JSONMuzzle muzzle : ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles) {
                this.setBulletSpawn(this.bulletPositionRender, this.bulletVelocityRender, this.bulletOrientationRender, muzzle, false);
                new BoundingBox(this.bulletPositionRender, 0.25, 0.25, 0.25).renderWireframe(this, transform, null, ColorRGB.BLUE);
            }
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        IWrapperNBT bulletData;
        int i;
        super.save(data);
        data.setInteger("state", (byte)this.state.ordinal());
        data.setInteger("bulletsFired", this.bulletsFired);
        data.setInteger("currentMuzzleGroupIndex", this.currentMuzzleGroupIndex);
        data.setPoint3d("internalAngles", this.internalOrientation.angles);
        for (i = 0; i < this.loadedBullets.size(); ++i) {
            bulletData = InterfaceManager.coreInterface.getNewNBTWrapper();
            bulletData.setPackItem((AJSONMultiModelProvider)this.loadedBullets.get((int)i).definition, "");
            bulletData.setInteger("count", this.loadedBulletCounts.get(i));
            data.setData("loadedBullet" + i, bulletData);
        }
        data.setInteger("loadedBulletsSize", this.loadedBullets.size());
        for (i = 0; i < this.reloadingBullets.size(); ++i) {
            bulletData = InterfaceManager.coreInterface.getNewNBTWrapper();
            bulletData.setPackItem((AJSONMultiModelProvider)this.reloadingBullets.get((int)i).definition, "");
            bulletData.setInteger("count", this.reloadingBulletCounts.get(i));
            data.setData("reloadingBullet" + i, bulletData);
        }
        data.setInteger("reloadingBulletsSize", this.reloadingBullets.size());
        data.setInteger("reloadStartTimeRemaining", this.reloadStartTimeRemaining);
        data.setInteger("reloadMainTimeRemaining", this.reloadMainTimeRemaining);
        data.setInteger("reloadEndTimeRemaining", this.reloadEndTimeRemaining);
        long randomSeed = this.randomGenerator.nextLong();
        data.setBoolean("savedSeed", true);
        data.setInteger("randomSeedPart1", (int)(randomSeed >> 32));
        data.setInteger("randomSeedPart2", (int)randomSeed);
        return data;
    }

    public static enum GunState {
        INACTIVE,
        ACTIVE,
        CONTROLLED,
        FIRING_REQUESTED,
        FIRING_CURRENTLY;


        public GunState promote(GunState newState) {
            return newState.ordinal() > this.ordinal() ? newState : this;
        }

        public GunState demote(GunState newState) {
            return newState.ordinal() < this.ordinal() ? newState : this;
        }

        public boolean isAtLeast(GunState testState) {
            return this.ordinal() >= testState.ordinal();
        }
    }
}

